unit FormOsoby;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, ActnList, Buttons;

type
  TFOsoby = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    ListView: TListView;
    SpeedButton1: TSpeedButton;
    ActionList1: TActionList;
    ActionClose: TAction;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure ActionCloseExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure pokaz_osoby();

    constructor Create(AOwner: TComponent); override;
  end;

var
  FOsoby: TFOsoby;

implementation

uses DataModule, DB;

{$R *.dfm}

constructor TFOsoby.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
//   ShowMessage('constructor');
end;


procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
   FOsoby := NIL;
end;

procedure TFOsoby.ActionCloseExecute(Sender: TObject);
begin
   Close();
end;

procedure TFOsoby.FormShow(Sender: TObject);
begin
   pokaz_osoby();
end;

procedure TFOsoby.Pokaz_osoby();
var
   i         : Integer;       // licznik
   NewColumn : TListColumn;   // nagwki kolumn
   ListItem  : TListItem;     // zawarto: kolumnami wiersze

   // pola tebeli osoby
   idosoby   : String;
   nazwisko  : String;
   imie      : String;
   dataur    : String;
   mcowosc   : String;
   ulicainr  : String;
   kodp      : String;
   miasto    : String;
   pesel     : String;

begin
   DM.SQLDataSet1.Open();

   // wygld ListView
   with ListView do begin
      Parent            := Self;
      Align             := alClient;
      ViewStyle         := vsReport;
      RowSelect         := True;
      ReadOnly          := True;
      Color             := clInfobk;
      GridLines         := True;
      ShowColumnHeaders := true;
   end;

   // nagwki kolumn
   with ListView do begin
      // kolumna id
      NewColumn         := Columns.Add;
      NewColumn.Caption := 'Idosoby';
      // NewColumn.Width   := 20;
      NewColumn.Width   := 0; // aby kolumna bya niewidoczna dla uytkownika

      // nazwisko
      NewColumn         := Columns.Add;
      NewColumn.Caption := 'Nazwisko';
      NewColumn.Width   :=  80;

      // imie
      NewColumn         := Columns.Add;
      NewColumn.Caption := 'Imi';
      NewColumn.Width   := 70;

      // dataur
      NewColumn         := Columns.Add;
      NewColumn.Caption := 'Data ur.';
      NewColumn.Width   := 80;

      // MCOWOSC
      NewColumn         := Columns.Add;
      NewColumn.Caption := 'Miejsce ur.';
      NewColumn.Width   := 90;

      // ulicainr
      NewColumn         := Columns.Add;
      NewColumn.Caption := 'Ulica i nr';
      NewColumn.Width   := 140;

      // kodp
      NewColumn         := Columns.Add;
      NewColumn.Caption := 'Kod p.';
      NewColumn.Width   := 70;

      // miasto
      NewColumn         := Columns.Add;
      NewColumn.Caption := 'Miejscowo';
      NewColumn.Width   := 80;

      // pesel
      NewColumn         := Columns.Add;
      NewColumn.Caption := 'Pesel';
      NewColumn.Width   := 100;
   end;

   with ListView do begin
      while not DM.SQLDataSet1.EOF do begin
         idosoby    := DM.SQLDataSet1.FieldValues['IDOSOBY'];
         idosoby    := DM.SQLDataSet1.Fields[0].AsVariant;

         idosoby    := DM.SQLDataSet1.FieldByName('IDOSOBY').AsString;
         nazwisko   := DM.SQLDataSet1.FieldByName('NAZWISKO').AsString;
         imie       := DM.SQLDataSet1.FieldByName('IMIE').AsString;
         dataur     := DM.SQLDataSet1.FieldByName('DATAUR').AsString;
         mcowosc    := DM.SQLDataSet1.FieldByName('MCOWOSC').AsString;
         ulicainr   := DM.SQLDataSet1.FieldByName('ULICAINR').AsString;
         kodp       := DM.SQLDataSet1.FieldByName('KODP').AsString;
         miasto     := DM.SQLDataSet1.FieldByName('MIASTO').AsString;
         pesel      := DM.SQLDataSet1.FieldByName('PESEL').AsString;

         ListItem := items.Add;

         // uwaga: do pierwszej kolumny mozna si odwoa przez Caption
         ListItem.Caption := idosoby;

         // Nastpne kolumny uzyskujemy poprzez SubItems[0,1,2,...]
         ListItem.SubItems.Add(nazwisko);
         ListItem.SubItems.Add(imie);
         ListItem.SubItems.Add(dataur);
         ListItem.SubItems.Add(mcowosc);
         ListItem.SubItems.Add(ulicainr);
         ListItem.SubItems.Add(kodp);
         ListItem.SubItems.Add(miasto);
         ListItem.SubItems.Add(pesel);

         DM.SQLDataSet1.Next();
      end;

      DM.SQLDataSet1.Close();
   end;
end;

end.
